<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head profile="http://">
  <title>Search for files</title>
  <style type="text/css" media="all">
    @import url("/styles/search.css");
    @import url("/styles/xtra.css");
  </style>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  
  <link rel="shortcut icon" href="/favicon.ico" />
  <link rel="contents" href="index.php" />
  <link rel="index" href="index.php" />
  <link rel="prev" href="prev.php" />
  <link rel="next" href="next.php" />
  <link rel="schema.dc" href="http://purl.org/dc/elements/1.1/" />
  <link rel="schema.rdfs" href="http://www.w3.org/2000/01/rdf-schema#" />
  <link rel="license" href="http://creativecommons.org/licenses/by/3.0/" />
</head>
<body><?php
set_time_limit(0);

$exclude_files = array(
	$_SERVER['DOCUMENT_ROOT'] . '/' . 'finngumblar.php');

function scan_files($dir) {
  
  global $exclude_files;
  
  // malware strings to search
  $search = array(
  'Quisque',
  'pesonality',
  '.cn/',
  'gumblar',
  'eval(unescape',
  'eval(base64_decode',
  'eval(decode',
  'eval(base',
  'base64_decode',
  '(function(){',
  'eval(String.fromCharCode',
  'neglite.com',
  'niklejo.net',
  //'',
  'internetcountercheck.com'
  );
  
  $dirs_array = array();
  
  if ($handle = opendir($dir)) {
    
    //echo ("Open dir: " . $dir . " ");
    //echo "<br />Files: ";
    //echo ("" . $dir . " ");
    //echo "<br />";
    echo "";
    
    // this is the correct way to loop over the directory.
    while (false !== ($file = readdir($handle))) {
      if ($file != '.' && $file != '..') {
        
        $path = $dir . $file;
        
        if (is_file($path)) {
          
          // skip large files
          if (filesize($path) > 1000000) {
            continue;
          } //IF
          
          // exlude files
          if (in_array($path, $exclude_files)) {
            continue;
          }//if
          
          // get content
          $file_handle = fopen($path, 'r');
          $contents = "";
          while (!feof($file_handle)) {
            $contents = fgets($file_handle);
            
            // loop for search string
            $found = false;
            foreach ($search as $search_string) {
                if (stristr($contents, $search_string)) {
                $found = true;
                break;
              }//if
            }//foreach
            //highlight_file
            if ($found == true) {
              echo ("  <tr>\n    <td> File :   ".($path) . "</td>");
              echo  ("\n    <td><strong> [ FOUND " . $search_string . " ]</strong></td>\n  </tr>\n");
              echo "";
              break;
              
            }//if
            else {
              //echo '[CLEAN]';
            }//else						
          }//if
          
          fclose($file_handle);
          
        } elseif (is_dir($path)) {
        	
          $dirs_array[] = $path;				
        }//elseif
        
      }//if
      
    }//while
    //echo 'x';
    closedir($handle);
  }//if
  //echo 't';
  foreach ($dirs_array as $dir) {
    scan_files($dir . '/');
    //echo 'x';
  }//foreach
  //echo 'x';
  unset($dirs_array);
}

$start_dir = $_SERVER['DOCUMENT_ROOT'] . '';
echo ("\n<p>");
echo ('Starting from: ' . $start_dir . '');
echo ('</p>');
echo "\n<table border='1'>\n";
scan_files($start_dir);
echo "</table>\n";
//echo ('</pre>');
?>
</body>
</html>